#ifndef __C4DBASECONTAINER_H
#define __C4DBASECONTAINER_H

#include "ge_math.h"
#include "ge_matrix.h"
#include "c4d_basetime.h"
#include "c4d_string.h"
#include "c4d_file.h"
#include "c4d_gedata.h"

class BaseDocument;
class BaseObject;
class BaseMaterial;

class BaseContainer
{
	friend class BaseObject;

	private:
		CHAR priv[20]; // fixed size of 20 bytes
	public:
		void* operator new(size_t,int line,const CHAR *file);
		void  operator delete(void *del);

		void* operator new(size_t,void *place) { return place; }
		void  operator delete(void*, void*) {}

		BaseContainer(void);
		BaseContainer(LONG id);              
		BaseContainer(const BaseContainer &n); 
		~BaseContainer(void);

		const BaseContainer &operator = (const BaseContainer &n);
		BaseContainer *GetClone(AliasTrans *trans) const;
		void CopyTo(BaseContainer *dst,AliasTrans *trans) const;

		void FlushAll(void); 

		LONG GetId(void) const; 
		void SetId(LONG c_id);  

		Bool RemoveData(LONG id);
		Bool RemoveIndex(LONG i);

		LONG FindIndex(LONG id) const;			
		LONG GetIndexId(LONG index) const;		

		GeDataType GetType(LONG id) const;
		GeDataType GetIndexType(LONG index) const;

		GeData *GetIndexData(LONG index) const;
		Bool InsData(LONG id, const GeData &n);
		Bool SetData(LONG id, const GeData &n);
		const GeData &GetData(LONG id) const;

		Bool operator == (const BaseContainer &d) const;
		Bool operator != (const BaseContainer &d) const;

		Bool 									GetBool			(LONG id, Bool preset=FALSE) const;
		LONG									GetLong			(LONG id, LONG preset=0) const;
		Real									GetReal			(LONG id, Real preset=0.0) const;
		Vector								GetVector		(LONG id, const Vector &preset=Vector()) const;
		Matrix								GetMatrix		(LONG id, const Matrix &preset=Matrix()) const;
		String								GetString		(LONG id, const String   &preset=String()) const;
		Filename							GetFilename	(LONG id, const Filename &preset=Filename()) const;
		BaseTime							GetTime			(LONG id, const BaseTime &preset=BaseTime()) const;
		BaseContainer					GetContainer(LONG id) const;
		BaseContainer*				GetContainerInstance(LONG id) const;
		BaseList2D*						GetLink					(LONG id, BaseDocument *doc, LONG instanceof=0) const;
		BaseObject*						GetObjectLink		(LONG id, BaseDocument *doc) const;
		BaseMaterial*					GetMaterialLink	(LONG id, BaseDocument *doc) const;
		BaseLink*							GetBaseLink (LONG id) const;
		const CustomDataType*	GetCustomDataType	(LONG id,LONG datatype) const;

		void SetBool				(LONG id, Bool b);
		void SetLong				(LONG id, LONG l);
		void SetReal				(LONG id, Real r);
		void SetVector			(LONG id, const Vector &v);
		void SetMatrix			(LONG id, const Matrix &m);
		void SetString			(LONG id, const String &s);
		void SetFilename		(LONG id, const Filename &f);
		void SetTime				(LONG id, const BaseTime &b);
		void SetContainer		(LONG id, const BaseContainer &s);
		void SetLink				(LONG id, BaseList2D *link);

		void MergeContainer(const BaseContainer &src);

		Bool GetParameter(const DescID &id, GeData &t_data);
		Bool SetParameter(const DescID &id, const GeData &t_data);
};

#endif
